<?php
/**
 * Tab migrator for yikes tab plugin.
 *
 * This plugin will migrate tabs from yikes tab plugin to wb tabs plugin.
 *
 * @link              https://profiles.wordpress.org/webbuilder143/
 * @since             1.0.0
 * @package           Tab_Migrator
 *
 * @wordpress-plugin
 * Plugin Name:       Tab migrator for yikes tab plugin.
 * Plugin URI:        https://profiles.wordpress.org/webbuilder143/
 * Description:       This plugin will migrate tabs from yikes tab plugin to wb tabs plugin.
 * Version:           1.0.0
 * Author:            Web Builder 143
 * Author URI:        https://profiles.wordpress.org/webbuilder143/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wb-yikes-tab-migrator
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants.
define( 'WB_YIKES_TAB_MIGRATOR_VERSION', '1.0.0' );

// Create an admin menu page.
function wb_yikes_tab_migrator_admin_menu() {
    add_menu_page(
        'Tab Migrator',
        'Tab Migrator',
        'manage_options',
        'wb-yikes-tab-migrator',
        'wb_yikes_tab_migrator_admin_page',
        'dashicons-admin-tools',
        6
    );
}

add_action( 'admin_menu', 'wb_yikes_tab_migrator_admin_menu' );

// Admin page callback function.
function wb_yikes_tab_migrator_admin_page() {
    // Three steps to migrate tabs from yikes tab plugin to wb tabs plugin.
    // 1. Get all tabs from yikes tab plugin.
    // 2. Verify the tabs.
    // 3. Migrate tabs from yikes tab plugin to wb tabs plugin.  
    $global_tabs = wb_get_yikes_reusable_product_tabs(); 
    ?>
    <style type="text/css">
       .wb-yikes-tab-migrator-step{ display:none; } 
       .wb-yikes-tab-migrator-step.active{ display:block; }
       .wb-yikes-tab-migrator-step-content, .wb-yikes-tab-migrator-step-content p{ font-size:16px; font-weight:500; color:#1e68f5; }
       .wb-yikes-tab-migrator-step h4{ margin-bottom:5px; }
       .wb-yikes-tab-migrator-step ol{ margin-top:5px; }
       .wb-yikes-tab-migrator-step ol li{ color:#333; font-size:12px; }
       .wb-yikes-tab-migrator-tab-fetch-loadmore{ background:#fff; padding:10px; box-sizing:border-box; margin:10px 0px; line-height:25px; }
    </style>
    <script>
        jQuery(document).ready(function(){

            jQuery(document).on('click', '.wb-yikes-tab-migrator-tab-fetch-btn, .wb-yikes-tab-migrator-tab-fetch-loadmore-btn', function(){

                jQuery(this).html('Loading');
                jQuery('.wb-yikes-tab-migrator-tab-fetch-loadmore').html('Loading');
                var wb_offset = jQuery(this).attr('data-offset');
                jQuery.ajax({
                    url: '<?php echo esc_url( admin_url('admin-ajax.php') );?>' + '?rand=' + new Date().getTime(),
                    type: 'POST',
                    data: {
                        action: 'wb_yikes_tab_migrator_fetch_tabs',
                        nonce: '<?php echo wp_create_nonce('wb_yikes_tab_migrator_fetch_tabs');?>',
                        offset: wb_offset
                    },
                    headers: {
                        'Cache-Control': 'no-cache'
                    },
                    success: function( response ) {
                        
                        jQuery('.wb-yikes-tab-migrator-tab-fetch-loadmore, .wb-yikes-tab-migrator-tab-btn-con').remove();
                        if(wb_offset > 0) {
                            jQuery('.wb-yikes-tab-migrator-tabs-list').append(response);
                        }else{
                            jQuery('.wb-yikes-tab-migrator-tabs-list').html(response);
                        }
                      
                        jQuery('.wb-yikes-tab-migrator-tab-fetch-btn').html('Fetch Tabs');

                        jQuery('.wb-yikes-tab-migrator-step').removeClass('active');
                        jQuery('#tab-migrator-step-2').addClass('active');
                    },
                    error: function( response ) {
                                             
                        if(jQuery('.wb-yikes-tab-migrator-tab-fetch-loadmore').length) {
                           jQuery('.wb-yikes-tab-migrator-tab-fetch-loadmore').html('<p>Unable to load tabs. <button class="wb-yikes-tab-migrator-tab-fetch-loadmore-btn" data-offset="'+wb_offset+'">Try again</button></p>'); 
                        }else{
                            jQuery('.wb-yikes-tab-migrator-tab-fetch-btn').html('Fetch Tabs');
                            jQuery('.wb-yikes-tab-migrator-tabs-list').html('<p>Error fetching tabs.</p>');
                        }
                    }
                });
            });

            jQuery(document).on('click', '.wb-yikes-tab-migrator-tab-back-btn', function(){
                jQuery('.wb-yikes-tab-migrator-step').removeClass('active');
                let step = jQuery(this).data('step');
                jQuery('#tab-migrator-step-' + step).addClass('active');
            });

            jQuery(document).on('click', '.wb-yikes-tab-migrator-tab-migrate-btn', function(){
                if(confirm('Are you sure? This will migrate the above listed tabs to Wb tabs plugin and delete the tabs from old plugin.')){

                    jQuery('.wb-yikes-tab-migrator-step').removeClass('active');
                    jQuery('#tab-migrator-step-3').addClass('active'); 

                    wb_yikes_tab_migrator_migrate_tabs();
                }             
            });

            function wb_yikes_tab_migrator_migrate_tabs(){
                
                jQuery.ajax({
                    url: '<?php echo esc_url( admin_url('admin-ajax.php') );?>' + '?rand=' + new Date().getTime(),
                    type: 'POST',
                    dataType: 'json',
                    headers: {
                        'Cache-Control': 'no-cache'
                    },
                    data: {
                        action: 'wb_yikes_tab_migrator_migrate_tabs',
                        nonce: '<?php echo wp_create_nonce('wb_yikes_tab_migrator_migrate_tabs');?>'
                    },
                    success: function(response){
                        jQuery('.wb-yikes-tab-migrator-migrate-log').append(response.msg+'<br />');
                        if(response.status == 1){
                            wb_yikes_tab_migrator_migrate_tabs(); //Next batch
                        }else if(response.status == 2){
                            jQuery('.wb-yikes-tab-migrator-migrate-log').append('Please check that all your tabs have migrated correctly. If you have any problems with the migrated tabs, let us know. Otherwise, you\'re good to uninstall the old plugin.');
                        }
                    },
                    error: function(response){
                        jQuery('.wb-yikes-tab-migrator-migrate-log').append('Error<br />');
                    }
                });
            }
        });
    </script>
    <div class="wrap">
        <h1>Tab Migrator</h1>
        <div class="wb-yikes-tab-migrator-steps">
            <div class="wb-yikes-tab-migrator-step active" id="tab-migrator-step-1">
                <h2>Step 1: Get all tabs from old tab plugin.</h2>
                <div class="wb-yikes-tab-migrator-step-content">
                    <p>Please install the WB Product Tabs plugin before migrating the tabs. Click the button below to fetch all tabs from the old plugin.</p>
                </div>
                <button class="button button-primary wb-yikes-tab-migrator-tab-fetch-btn" data-offset="0">Fetch Tabs</button>
            </div>
            <div class="wb-yikes-tab-migrator-step" id="tab-migrator-step-2">
                <h2>Step 2: Verify the tabs.</h2>
                <div class="wb-yikes-tab-migrator-step-content wb-yikes-tab-migrator-tabs-list">
                    
                </div>
            </div>
            <div class="wb-yikes-tab-migrator-step" id="tab-migrator-step-3">
                <h2>Step 3: Migrating tabs from old tab plugin to WB tabs plugin.</h2>
                <div class="wb-yikes-tab-migrator-step-content wb-yikes-tab-migrator-migrate-log">
                    Migrating....<br />
                </div>
            </div>
        </div>
    </div>
    <?php
}

add_action('wp_ajax_wb_yikes_tab_migrator_fetch_tabs', 'wb_yikes_tab_migrator_fetch_tabs');
function wb_yikes_tab_migrator_fetch_tabs() {
    
    // Add nonce check.
    if( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'wb_yikes_tab_migrator_fetch_tabs' ) ) {
        echo 'Unauthorized access.';
        die();
    }

    $global_tabs = wb_get_yikes_reusable_product_tabs();
    $to_import_global_tabs = array();
    $to_import_specific_tabs = array();
    $to_show_tabs = array();
    
    foreach ($global_tabs as $id => $global_tab) {
        
        $tab_id = isset( $global_tab['tab_id'] ) ? $global_tab['tab_id'] : $id;

        $to_import_global_tabs[ $tab_id ] = array(
            'tab_id' => isset( $global_tab['tab_id'] ) ? $global_tab['tab_id'] : 0,
            'tab_title' => isset( $global_tab['tab_title'] ) ? $global_tab['tab_title'] : '',
            'tab_nickname' => isset( $global_tab['tab_name'] ) ? $global_tab['tab_name'] : '',
            'tab_slug' => isset( $global_tab['tab_slug'] ) ? $global_tab['tab_slug'] : '',
            'tab_content' => isset( $global_tab['tab_content'] ) ? $global_tab['tab_content'] : '',
            'tab_priority' => 25,
            'tab_products' => array(),
        );
    }

    global $wpdb;
    $tb = $wpdb->prefix . 'postmeta';
    $offset = isset($_POST['offset']) ? absint($_POST['offset']) : 0;
    $limit = 100;
    $id_product_tabs = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT post_id,meta_value FROM $tb WHERE meta_key='yikes_woo_products_tabs' AND meta_value != 'a:0:{}' ORDER BY post_id ASC LIMIT %d,%d", $offset, $limit));
    $saved_tabs_applied = wb_get_yikes_reusable_product_tabs_applied();
 
    if ( ! empty( $id_product_tabs ) ) {
        foreach ( $id_product_tabs as $post ) {
            
            $product_id = $post->post_id;
            $product_tabs = get_post_meta( $product_id, 'yikes_woo_products_tabs', true );
                           
            if( !empty($product_tabs) && is_array($product_tabs) ) {
                
                $tab_priority = 25;
                $to_import_specific_tabs[ $product_id ] = array();
                $to_show_tabs[ $product_id ] = array();

                foreach( $product_tabs as $product_tab_k => $product_tab ) { 

                    $tab_priority++;

                    $to_show_tabs_arr = array(
                        'title' => isset( $product_tab['title'] ) ? $product_tab['title'] : '',
                        'tab_id' => 0,
                    );

                    if( isset($saved_tabs_applied[$product_id]) && is_array($saved_tabs_applied[$product_id]) ) {
                        
                        foreach ($saved_tabs_applied[$product_id] as $tabs_applied) {
                            
                            // Its an attached global tab.
                            if( ! empty( $tabs_applied['tab_id'] ) &&  
                                ! empty( $product_tab['id'] ) && 
                                $product_tab['id'] === $tabs_applied['tab_id'] && 
                                isset( $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ] ) 
                            ) { 
                                //echo $product_id, '---', $tabs_applied['reusable_tab_id'], '<br />';
                                $to_show_tabs_arr['tab_id'] = $tabs_applied['reusable_tab_id'];
                                unset( $product_tabs[ $product_tab_k ] ); 
                                $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ]['tab_priority'] = $tab_priority;
                                $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ]['tab_products'][] = $product_id;
                                break;
                            }
                        }
                    }

                    $to_show_tabs[ $product_id ][] = $to_show_tabs_arr;


                    // Product specific tabs.
                    if( isset( $product_tabs[ $product_tab_k ] ) ) { // If this tab not found on global tabs.
                        $to_import_specific_tabs[ $product_id ][] = array(
                            'tab_title' => isset( $product_tab['title'] ) ? $product_tab['title'] : '',
                            'tab_nickname' => '',
                            'tab_slug' => isset( $product_tab['id'] ) ? $product_tab['id'] : '',
                            'tab_content' => isset( $product_tab['content'] ) ? $product_tab['content'] : '',
                            'tab_priority' => $tab_priority,
                        );
                    }
                }
            }          
        }
    }


    if( ! empty( $to_show_tabs ) ) {
        if ( 0 === $offset ) {
        ?>
            Before proceeding with the migration, please ensure all your tabs are listed here.
        <?php
        }

        $j = $offset;
        foreach ($to_show_tabs as $product_id => $tabs) {
            $product = wc_get_product($product_id);
            $j++;

            if ($product && ! empty( $tabs ) ) {
                ?>
                <h4> <?php echo $j;?>. <a href="<?php echo esc_url(get_permalink($product_id));?>" target="_blank"><?php echo esc_html( $product->get_name() ); ?></a> </h4>
                <ol>
                    <?php
                    foreach ($tabs as $tab_data) { //
                        ?>
                        <li><?php echo esc_html( $tab_data['title'] ); ?>
                            <?php 
                            if ( $tab_data['tab_id'] > 0 ) { // Global tab.
                                ?>
                                 <a href="<?php echo esc_url(admin_url('admin.php?page=yikes-woo-settings&saved-tab-id='.$tab_data['tab_id']));?>" target="_blank">View saved tab</a>
                                <?php
                            }
                            ?>
                        </li>
                        <?php
                    }
                    ?>
                </ol>
                <?php
            }
        }

        // Check more records are there to show.
        $new_offset = $offset + $limit;
        $next_id_product_tabs = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT post_id FROM $tb WHERE meta_key='yikes_woo_products_tabs' AND meta_value != 'a:0:{}' ORDER BY post_id ASC LIMIT %d,%d", $new_offset, 1));

        if ( ! empty( $next_id_product_tabs ) ) { // Next set of record exists. Show Load more button.
            $total =  $wpdb->get_var("SELECT COUNT( DISTINCT post_id ) AS ttl FROM $tb WHERE meta_key='yikes_woo_products_tabs' AND meta_value != 'a:0:{}'");
            ?>
            <div class="wb-yikes-tab-migrator-tab-fetch-loadmore">
                <?php echo $j, ' out of ', $total, ' loaded. ';?>
                <button class="button button-secondary wb-yikes-tab-migrator-tab-fetch-loadmore-btn" data-offset="<?php echo $new_offset;?>">Load more</button>
            </div>
            <?php
        }

        ?>
        <div class="wb-yikes-tab-migrator-tab-btn-con">
            <button class="button button-primary wb-yikes-tab-migrator-tab-back-btn" data-step="1">Back</button> &nbsp;
            <button class="button button-primary wb-yikes-tab-migrator-tab-migrate-btn">Migrate tabs</button>
        </div>
        <?php
    }else{
        if(0 === $offset) {
        ?>
        <p>No tabs found to migrate</p>
        <button class="button button-primary wb-yikes-tab-migrator-tab-back-btn" data-step="1">Back</button> &nbsp;
        <?php
        }
    }

    die();
}


add_action('wp_ajax_wb_yikes_tab_migrator_migrate_tabs', 'wb_yikes_tab_migrator_migrate_tabs');
function wb_yikes_tab_migrator_migrate_tabs() {
    
    // Add nonce check.
    if( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'wb_yikes_tab_migrator_migrate_tabs' ) ) {
        wp_send_json_error(array('status' => 0, 'msg' => 'Unauthorized access.'));
        die();
    }
    
    // Fetch already processed tabs data in the previous batch.
    $to_import_global_tabs = get_option('wb_yikes_woo_reusable_products_tabs_processed', array());

    if ( empty( $to_import_global_tabs ) ) { // First batch.
        
        $global_tabs = wb_get_yikes_reusable_product_tabs();

        foreach ($global_tabs as $id => $global_tab) {
            
            $tab_id = isset( $global_tab['tab_id'] ) ? $global_tab['tab_id'] : $id;

            $to_import_global_tabs[ $tab_id ] = array(
                'tab_id' => isset( $global_tab['tab_id'] ) ? $global_tab['tab_id'] : 0,
                'tab_title' => isset( $global_tab['tab_title'] ) ? $global_tab['tab_title'] : '',
                'tab_nickname' => isset( $global_tab['tab_name'] ) ? $global_tab['tab_name'] : '',
                'tab_slug' => isset( $global_tab['tab_slug'] ) ? $global_tab['tab_slug'] : '',
                'tab_content' => isset( $global_tab['tab_content'] ) ? $global_tab['tab_content'] : '',
                'tab_priority' => 25,
                'tab_products' => array(),
            );
        }
    }


    global $wpdb;
    $tb = $wpdb->prefix . 'postmeta';
    $id_product_tabs = $wpdb->get_results("SELECT DISTINCT post_id FROM $tb WHERE meta_key='yikes_woo_products_tabs' ORDER BY post_id ASC LIMIT 100");
    $saved_tabs_applied = wb_get_yikes_reusable_product_tabs_applied();
    $migrated_products = 0;
    
    if ( ! empty( $id_product_tabs ) ) {
        
        foreach ( $id_product_tabs as $post ) {
            
            $product_id = $post->post_id;
            $product_tabs = get_post_meta( $product_id, 'yikes_woo_products_tabs', true );
                        
            if( !empty($product_tabs) && is_array($product_tabs) ) {
                
                $migrated_products++;

                $tab_priority = 25;

                // Took WB tabs
                //$to_import_specific_tabs = get_post_meta( $product_id, 'wb_custom_tabs', true );
                //$to_import_specific_tabs = is_array( $to_import_specific_tabs ) ? $to_import_specific_tabs : array();
                $to_import_specific_tabs = array(); // Not considering tabs created via wb tabs.
                $existing_tab_count = count( $to_import_specific_tabs );

                foreach( $product_tabs as $product_tab_k => $product_tab ) {

                    $tab_priority++;

                    // Global
                    if( isset($saved_tabs_applied[$product_id]) && is_array($saved_tabs_applied[$product_id]) ) {
                        foreach ($saved_tabs_applied[$product_id] as $tabs_applied) {
                            
                            // Its an attached global tab.
                            if( ! empty( $tabs_applied['tab_id'] ) &&  
                                ! empty( $product_tab['id'] ) && 
                                $product_tab['id'] === $tabs_applied['tab_id'] && 
                                isset( $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ] ) 
                            ) {
                                unset( $product_tabs[ $product_tab_k ] ); 
                                $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ]['tab_priority'] = $tab_priority;
                                $to_import_global_tabs[ $tabs_applied['reusable_tab_id'] ]['tab_products'][] = absint($product_id);
                                break;
                            }
                        }
                    }


                    // Product specific tabs.
                    if( isset( $product_tabs[ $product_tab_k ] ) ) { // If this tab not found on global tabs.
                        $to_import_specific_tabs[] = array(
                            'title' => isset( $product_tab['title'] ) ? $product_tab['title'] : '',
                            'content' => isset( $product_tab['content'] ) ? $product_tab['content'] : '',
                            'tab_type' => 'local',
                            'position' => $tab_priority,
                            'nickname' => '',
                        );
                    }
                }


                // If new tabs from old plugin.
                if ( $existing_tab_count < count( $to_import_specific_tabs ) ) {
                    // Migrate to WB tabs.
                    update_post_meta( $product_id, 'wb_custom_tabs', $to_import_specific_tabs );
                }           
            }

            // backup old plugin data for safety.
            $wpdb->update(
                $tb,               // Table name
                array( 'meta_key' => 'yikes_woo_products_tabs_migrated' ),
                array( 'post_id' => $product_id, 'meta_key' => 'yikes_woo_products_tabs'),
                array( '%s' ), 
                array( '%d', '%s' )
            );
        }

        // Save the processed global tabs for next batch.
        update_option( 'wb_yikes_woo_reusable_products_tabs_processed', $to_import_global_tabs );

        echo wp_json_encode(array('status' => 1, 'msg' => 'Tabs migrated for ' . $migrated_products . ' products'));

    }else { // All product specific tabs are migrated.

        if( ! empty( $to_import_global_tabs ) ) { // Global tabs are there to migrate.

            foreach ( $to_import_global_tabs as $key => $global_tab ) {
                
                // Insert a new wb-custom-tabs post
                $tab_data = array(
                    'post_title'    => $global_tab['tab_title'],    // Tab title
                    'post_content'  => $global_tab['tab_content'], // Tab content
                    'post_status'   => 'publish',          // Post status (publish, draft, etc.)
                    'post_type'     => 'wb-custom-tabs',   // Your custom post type
                    'meta_input'    => array(
                        '_wb_tab_position' => $global_tab['tab_priority'],
                        '_wb_tab_nickname' => $global_tab['tab_nickname'],
                        '_wb_tab_products' => array_unique( $global_tab['tab_products'] ),
                    )
                );

                $post_id = wp_insert_post($tab_data);
            }

            // Rename `yikes_woo_reusable_products_tabs` option data for backup purpose.
            update_option('yikes_woo_reusable_products_tabs_migrated', get_option('yikes_woo_reusable_products_tabs'));
            delete_option('yikes_woo_reusable_products_tabs');
        }

        //add_option('wb_yikes_woo_products_tabs_migrated', 1);
        update_option('wb_cptb_global_tabs_behavior', 1); // Change default tab behaviour.
        echo wp_json_encode(array('status' => 2, 'msg' => 'Finished'));
    }

    //yikes_woo_products_tabs
    //yikes_woo_reusable_products_tabs_applied
    //yikes_woo_reusable_products_tabs
    //yikes_cpt_use_the_content
    die();
}

function wb_get_yikes_reusable_product_tabs() {
    return get_option('yikes_woo_reusable_products_tabs', array());
}

function wb_get_yikes_reusable_product_tabs_applied() {
    return get_option('yikes_woo_reusable_products_tabs_applied', array());
}